﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Net;
using System.IO;
using System.Web;




namespace CS_iSMS_Tester
{
    public partial class MainForm : Form
    {
        //---------Send Variables------------------------------------
        // The smsHTTP class is used to send messages and queries to iSMS using HTTP.
        private smsHTTP Send_HTTP_Sender = new smsHTTP();
        // The smsTCP class is used to send messages and queries to iSMS using TCP.
        private smsTCP Send_TCP_Sender = new smsTCP();
        // The smsParser class is used to parse responses from the iSMS.
        private smsParser Send_Response_Parser = new smsParser();
        String Send_Request_String = "";
        private String Send_tcpIPAddress = ""; // Used by timer function to track iSMS IP address when using TCP.
        private int Send_tcpPort = 2040; // Used by timer function to track iSMS Port when using TCP.
        Encoding unicode = System.Text.Encoding.Unicode;
        Encoding utf8encode = System.Text.Encoding.UTF8;
        Encoding isoencode = System.Text.Encoding.GetEncoding(28591);
        byte[] Send_encBytes;
        private String Send_LastMsgID = "";
        private bool send_status_scrollbottom = true;

        private String Send_IPAddress = "192.168.2.232";
        private String Send_Port = "81";
        private String Send_Username = "admin";
        private String Send_Password = "admin";
        private bool Send_isHTTP = true; // Whether the query should be sent using HTTP. False=TCP.
        private String Send_To = ""; //17632343856"; //34,17637425081,17637425021,17637425060";
        private String Send_toGroup = "";
        private int Send_Priority = 2;
        private String Send_Modem = "";
        private int Send_Encoding = 0;
        string Send_SMSText = "TestSMS";
        private bool iso_enabled = true;

        int number_count = 1;
        int total_numbers = 0;
        string[] number_list = new string[10];

                
        //--------Receive Variables-----------------------------
        private bool Recv_Update_Table = true;
        private int Recv_Table_Max_Rows = 100;
        private int Recv_Table_Row_Count = -1;
        private int Recv_Messages_Count = 0;

        //private const int Recv_SMS_Log_Max = 102;
        //iSMSmessage[] Recv_SMS_Log = new iSMSmessage[Recv_SMS_Log_Max];
        
        // The iSMSparseXML class is used to parse message info from XML responses from the iSMS.
        private iSMSnonpollingMsgParser doParseMsg = new iSMSnonpollingMsgParser();
        // The HTTPServer Class uses HttpListener to listen for and receive HTTP requests.
        private HTTPServer theHTTPserver = new HTTPServer();
        // The TCPServer Class uses TcpListener to listen for TCP connections and retrieves TCP messages.
        private TCPserver theTCPserver = new TCPserver();
        // Track number of messages in Message Table
        //private int Recv_Table_NumberOfMessages = 0;
        // Track whether it is currently using HTTP, or TCP.
        private bool Recv_isHTTP = true;
        private int Recv_Port = 8080;
        private String Recv_Domain = "192.168.2.106";

        //------Log Variables-----------------------------------
        private bool logs_enable = false;
        private string logs_folder = "c:\\Captures\\";
        private string logs_prefix = "nonpolling-";
        private string logs_sendlive_name = "sendlive.log";
        private string logs_sendmsg_name = "sendmsg.log";
        private string logs_sendfail_name = "sendfail.log";
        private string logs_recvlive_name = "recvlive.log";
        private string logs_recvmsg_name = "recvmsg.log";
        private string Delim = ", ";
        private string MsgHeader = "[msgtxt]";
        private string MsgFooter = "[/msgtxt]";
                        
        //-------Test Variables----------------------------------
        private bool recv_running = false;
                     

        public MainForm()
        {
            InitializeComponent();
            
            //-------INIT SEND DIALOGS---------------------
            // Initialize Protocol Combo Box
            Send_Protocol_comboBox.Items.Add("HTTP");
            Send_Protocol_comboBox.Items.Add("TCP");
            Send_Protocol_comboBox.SelectedIndex = 0;
            // Initialize Send SMS Encoding Combo Box
            Send_Enc_combobox.Items.Add("ASCII");
            Send_Enc_combobox.Items.Add("Extended ASCII");
            Send_Enc_combobox.Items.Add("Unicode");
            Send_Enc_combobox.SelectedIndex = 0;
            Update_Send_Dialogs();
                       

            //-------INIT RECV DIALOGS--------------------------
            // Add HTTP and TCP options to combobox. Default to HTTP.
            Recv_Protocol_comboBox.Items.Add("HTTP");
            Recv_Protocol_comboBox.Items.Add("TCP");
            Recv_Protocol_comboBox.SelectedIndex = 0;
            tableSize_textBox.Text = Recv_Table_Max_Rows.ToString();
            Recv_UpdateDialogs();
            /*int i;
            for (i = 0; i < Recv_SMS_Log_Max; i++)
                Recv_SMS_Log[i] = new iSMSmessage();*/

            // Set the function that will be called when a message is received from iSMS.
            theTCPserver.SetEventHandler(iSMS_MsgHandler);
            theHTTPserver.SetEventHandler(iSMS_MsgHandler);

            iso_enabled = true;
            theHTTPserver.iso_enabled = true;

            Logs_UpdateDialog();
        }

        

        private void Recv_UpdateDialogs()
        {
            if (Recv_isHTTP)
                Recv_Protocol_comboBox.SelectedIndex = 0;
            else
                Recv_Protocol_comboBox.SelectedIndex = 1;
            Recv_Port_textBox.Text = Recv_Port.ToString();
            Recv_Domain_textBox.Text = Recv_Domain;

        }


        private String decode_unicode_string(String unicode_str)
        {
            if (unicode_str.Length < 4) return unicode_str;
            String decoded_str = "";
            int cur_pos = 2;
            Byte[] str_bytes = new Byte[512];
            int count = 0;
            while (cur_pos < unicode_str.Length)
            {
                string tmp = unicode_str.Substring(cur_pos, 2);
                str_bytes[count] = Byte.Parse(tmp, System.Globalization.NumberStyles.HexNumber);
                count++;
                cur_pos += 4;
            }
            decoded_str = ASCIIEncoding.UTF8.GetString(str_bytes, 0, count);
            return decoded_str;
        }

        // A delegate is used to handle cross threading.
        private delegate void TheThreadFixer(); //String serverProtocol); //, EventArgs e);
        public void iSMS_MsgHandler() //String serverProtocol) //, EventArgs e)
        {
            if (InvokeRequired)
            {
                var s = new TheThreadFixer(iSMS_MsgHandler);
                Invoke(s, new object[] { });
                return;
            }

            String iSMSresponse = "";
            if (Recv_isHTTP)
                iSMSresponse = theHTTPserver.iSMSresponse;
            else
                iSMSresponse = theTCPserver.iSMSresponse;
                        
            if (logs_enable && logs_recvlive_name.Length > 0)
            {
                DateTime now = DateTime.Now;
                Logger(logs_recvlive_name, "[" + now + "]\r\n" + iSMSresponse + "\r\n\r\n");
            }

            // Display iSMS raw messages
            //iRecv_SMS_Log_richTextBox.Text = "\niSMS sent the Message:\n" + iSMSresponse;
            // Parse SMS messages. Get number of messages parsed.
            int MsgCount = doParseMsg.ParseMessages(iSMSresponse);
            if (MsgCount > 0)
            {
                for (int i = 1; i <= MsgCount; ++i)
                {
                    iSMSmessage theSMS = new iSMSmessage();
                    theSMS = doParseMsg.GetParsedSMS(i);
                        
                    String logentry = "";
                    if (logs_enable)
                    {
                        DateTime now = DateTime.Now;
                        logentry = "[" + now + "]" + Delim;
                        if (Recv_isHTTP)
                            logentry += "HTTP";
                        else
                            logentry += "TCP";
                        logentry += Delim + theSMS.MessageIndex.ToString() + Delim;
                        logentry += theSMS.ModemInfo.ToString() + Delim;
                        logentry += theSMS.SenderNumber.ToString() + Delim;
                        logentry += theSMS.Time.ToString() + Delim;
                        logentry += theSMS.Date.ToString() + Delim;
                        logentry += theSMS.EncodingFlag.ToString() + Delim;
                        logentry += MsgHeader + theSMS.Message.ToString() + MsgFooter;

                        if (logs_recvmsg_name.Length > 0)
                            Logger(logs_recvmsg_name, logentry);
                    }

                    if (theSMS.Error != true)
                    {
                        Recv_Port_textBox.Enabled = false;
                        AddSMStoTable(theSMS);
                    }

                    string cmpMessge = theSMS.Message;
                    if (theSMS.EncodingFlag == "Unicode")
                    {
                        cmpMessge = decode_unicode_string(cmpMessge);
                    }
                }
                Recv_Update_Table = true;   
            }
        }

                        
        private void AddSMStoTable(iSMSmessage addSMS)
        {
            if (Recv_Table_Row_Count < (Recv_Table_Max_Rows-1))
                Recv_Table_Row_Count++;
            else
                Messages_dataGridView.Rows.RemoveAt(0);

            if (Recv_Table_Row_Count < 0) // || (Recv_Table_Row_Count>(Messages_dataGridView.RowCount-1)))
            {
                Send_Status_richTextBox.Text += "Error! Invalid table row."; // Row: " + Recv_Table_Row_Count.ToString() + "\n";
                return;
            }

            Recv_Messages_Count++;
            if (Recv_Messages_Count > 9999)
                Recv_Messages_Count = 1;
            
            // Add a Row for message
            Messages_dataGridView.Rows.Add(1);

            //MessageBox.Show("Adding table row. Recv_Table_Row_Count:" + Recv_Table_Row_Count.ToString() + ", Recv_Messages_Count:" + Recv_Messages_Count.ToString() + ", table number of rows:" + Messages_dataGridView.RowCount.ToString());
                        
            //int MsgRow = Recv_Table_NumberOfMessages - 1; // Table rows start at zero, so subtract one.
            // Fill in table.
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[0].Value = Recv_Messages_Count;
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[1].Value = addSMS.MessageIndex;
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[2].Value = addSMS.ModemInfo;
            if (addSMS.SenderNumber.StartsWith("+")) // Remove + from SenderNumber before displaying
                Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[3].Value = addSMS.SenderNumber.TrimStart("+".ToCharArray());
            else
                Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[3].Value = addSMS.SenderNumber;
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[4].Value = addSMS.Date;
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[5].Value = addSMS.Time;
            Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[6].Value = addSMS.EncodingFlag;
            
            if (addSMS.EncodingFlag == "Unicode")
                Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[7].Value = decode_unicode_string(addSMS.Message);
            else
                Messages_dataGridView.Rows[Recv_Table_Row_Count].Cells[7].Value = addSMS.Message;
        }

        private void Update_SMSTable()
        {
            
            //int pos = Messages_dataGridView.AutoScrollOffset.Y;
            int pos = Messages_dataGridView.FirstDisplayedScrollingRowIndex; // .AutoScrollOffset;            
            if (AutoScroll_checkBox.Checked)
            {
                int last_row = Messages_dataGridView.RowCount - 1;
                if (last_row>0)
                    Messages_dataGridView.FirstDisplayedScrollingRowIndex = last_row; // Recv_Table_Row_Count - 1; //Recv_Table_NumberOfMessages - 1;
            }
            else
            {
                if (pos >= 0 && pos < Messages_dataGridView.RowCount)
                    Messages_dataGridView.FirstDisplayedScrollingRowIndex = pos; // .Y = pos;
            }
            
        }

        // Function is called when the MainForm is closed, ending the program.
        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            // Programming is ending, shutdown servers.
            if (Recv_isHTTP)
                theHTTPserver.CloseServer();
            else
                theTCPserver.CloseServer();
        }

        private void Protocol_comboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if ((string)Recv_Protocol_comboBox.SelectedItem == "HTTP")
                Recv_Domain_textBox.Enabled = true;
            else
                Recv_Domain_textBox.Enabled = false;
        }

        private void Messages_dataGridView_CellMouseUp(object sender, DataGridViewCellMouseEventArgs e)
        {
            int cRow = e.RowIndex+1;
            //Recv_ShowRawMsg_richTextBox.Text = "\niSMS sent the Message:\n" + Recv_SMS_Log[cRow].iSMS_Message;
        }

        private void Recv_Timer_Tick(object sender, EventArgs e)
        {
            if (Recv_Update_Table) Update_SMSTable();
            Recv_Update_Table = false;
        }

        private void MainForm_Resize(object sender, EventArgs e)
        {
            if (MainForm.ActiveForm.Height<=734)
                Messages_dataGridView.Height = 465;
            else
                Messages_dataGridView.Height = MainForm.ActiveForm.Height - 269; // 314;
            
            //Messages_dataGridView.Bottom = MainForm.bottom
            //Messages_dataGridView.Height = MainForm.ActiveForm.Height - 314;
            //Recv_ClearTable_button.Top = Messages_dataGridView.Bottom + 10;
            //Clear_button.Bottom = Clear_button.Top + 50;
        }

        
        private void Logs_UpdateDialog()
        {
            Logs_Folder_textBox.Text = logs_folder;
            Logs_Prefix_textBox.Text = logs_prefix;
            if (logs_enable == true)
            {
                Logs_Folder_label.Enabled = false;
                Logs_Folder_textBox.Enabled = false;
                Logs_Prefix_label.Enabled = false;
                Logs_Prefix_textBox.Enabled = false;
                Start_Log_button.Text = "Stop Logging";
            }
            else
            {
                Logs_Folder_label.Enabled = true;
                Logs_Folder_textBox.Enabled = true;
                Logs_Prefix_label.Enabled = true;
                Logs_Prefix_textBox.Enabled = true;
                Start_Log_button.Text = "Start Logging";
            }
        }

        private void Update_Send_Dialogs()
        {
            Send_IPAddress_textBox.Text = Send_IPAddress;
            Send_Port_textBox.Text = Send_Port.ToString();
            Send_Username_textBox.Text = Send_Username;
            Send_Password_textBox.Text = Send_Password;
            if (Send_isHTTP)
                Send_Protocol_comboBox.SelectedIndex = 0;
            else
                Send_Protocol_comboBox.SelectedIndex = 1;
            Send_To_textBox.Text = Send_To;
            Send_toGroup_textBox.Text = Send_toGroup;
            Send_Priority_textbox.Text = Send_Priority.ToString();
            Send_Modem_textBox.Text = Send_Modem;

            if (Send_Encoding>0 && Send_Encoding < Send_Enc_combobox.MaxDropDownItems)
                Send_Enc_combobox.SelectedIndex = Send_Encoding;
                        
            Send_Message_richTextBox.Text = Send_SMSText;
        }
                

        private void do_tick()
        {
            String livemsg = "";
            
            if (total_numbers > 1)
            {
                if (++number_count > total_numbers) number_count = 1;
            }
            // Initialize string to hold iSMS response to send message
            String stringID = "";
                        
            Send_SMSText = Send_Message_richTextBox.Text;
            string enc_text = enc_message(Send_SMSText);
            enc_text = "&text=" + enc_text; // +Send_SMSText;
            if (total_numbers > 0)
                enc_text = "&to=" + "\"" + number_list[number_count] + "\"" + enc_text;
            // Check if using HTTP or TCP to send messages.
            if (Send_isHTTP)
            {
                // Show message that was sent to iSMS
                livemsg = "Message sent to iSMS:\n" + Send_Request_String + enc_text;
                // Use smsHTTP class to send HTTP SMS message and get response from iSMS.
                stringID = Send_HTTP_Sender.SendHTTPMessage(Send_Request_String + enc_text);
            }
            else
            {
                livemsg = "Message sent to iSMS:\n" + Send_Request_String + enc_text;
                stringID = Send_TCP_Sender.SendTCPMessage(Send_tcpIPAddress, Send_tcpPort, Send_Request_String + enc_text + "\r\n");
            }
            // Show response from iSMS
            livemsg += "\n\niSMS Send Response: " + stringID;
            Send_Status_richTextBox.AppendText(livemsg);
            
            if (logs_enable && logs_sendlive_name.Length>0)
                Logger(logs_sendlive_name, livemsg);
            DateTime now = DateTime.Now;
            String sID = stringID;
            if (stringID.Length > 2)
                stringID.Substring(0, stringID.Length - 2);//????? sento no longer valid 
            String logentry = "[" + now + "]" + Delim + Send_To + Delim + Send_toGroup + Delim + MsgHeader + Send_SMSText + MsgFooter + Delim + sID; // +"\r\n";

            // Use smsParser class to get the SMS ID. If the returned ID is under 0, there was an error.
            int smsID = Send_Response_Parser.ParseID(stringID);
            // Check if there was an error sending SMS message.
            if (smsID < 0)
            {          
                // Log Failure                
                if (logs_enable && logs_sendfail_name.Length > 0)
                    Logger(logs_sendfail_name, logentry);

                // There was an error sending the SMS message.
                Send_Status_richTextBox.AppendText("\nFailed to to send SMS to iSMS");
                // Check if an error code was returned. If smsID=-2, an error code was returned.
                if (smsID == -2)
                {
                    // Error code was returned.
                    // Use smsParser class to get the description of the error.
                    String errorDesc = Send_Response_Parser.GetErrorDesc(stringID);
                    Send_Status_richTextBox.AppendText("\n" + errorDesc);
                }
                return;
            }
            // Log Successful Message 
            if (logs_enable && logs_sendmsg_name.Length > 0)
                Logger(logs_sendmsg_name, logentry);
            
            // The SMS message send to iSMS was successful.
            // Show iSMS response to send message.
            Send_Status_richTextBox.AppendText("\nSMS ID=" + smsID.ToString());
            Send_LastMsgID = smsID.ToString();// Set last msg id
        }

        
        private void Tools_QJobs_Query_button_Click(object sender, EventArgs e)
        {
            if ((string)Send_Protocol_comboBox.SelectedItem == "HTTP")
                Send_isHTTP = true;
            else
                Send_isHTTP = false;

            // Get data from dialog items and verify that all dialogs were filled in.
            // Prep SMS info strings to make build SMS message easier later.
            string smsIPAddress = Send_IPAddress_textBox.Text;
            if (smsIPAddress.Length < 4)
            {
                Send_Status_richTextBox.AppendText("Please enter the iSMS IP Address");
                return;
            }

            string smsPort = Send_Port_textBox.Text;
            if (smsPort.Length > 0)
                smsPort = ":" + smsPort;
            else
            {
                Send_Status_richTextBox.AppendText("Please enter a Port number");
                return;
            }

            string smsUsername = Send_Username_textBox.Text;
            if (smsUsername.Length > 0)
                smsUsername = "user=" + smsUsername;
            else
            {
                Send_Status_richTextBox.AppendText("Please enter a Username");
                return;
            }

            string smsPassword = Send_Password_textBox.Text;
            if (smsPassword.Length > 0)
                smsPassword = "&passwd=" + smsPassword;
            else
            {
                Send_Status_richTextBox.AppendText("Please enter a Password");
                return;
            }


            string smsPriority = QJobs_priority_textbox.Text;
            if (smsPriority.Length > 0)
                smsPriority = "&priority=" + smsPriority;
            else
                smsPriority = "&priority=0";

            string smsJQuery;

            if (Send_isHTTP)
                smsJQuery = "http://" + smsIPAddress + smsPort + "/queryjobs?" + smsUsername + smsPassword + smsPriority;
            else
            {
                // The Message will be sent using TCP
                smsJQuery = "/queryjobs?" + smsUsername + smsPassword + smsPriority + "\r\n";
                Send_tcpIPAddress = smsIPAddress;
                Send_tcpPort = Convert.ToInt32(smsPort = Send_Port_textBox.Text, 10);
            }

            string respon;
            if (Send_isHTTP)
            {
                // Show message that was sent to iSMS
                Send_Status_richTextBox.AppendText("Query Jobs:\n" + smsJQuery);
                // Use smsHTTP class to send HTTP SMS message and get response from iSMS.
                respon = Send_HTTP_Sender.SendHTTPMessage(smsJQuery);
            }
            else
            {
                Send_Status_richTextBox.AppendText("Query Jobs:\n" + smsJQuery);
                respon = Send_TCP_Sender.SendTCPMessage(Send_tcpIPAddress, Send_tcpPort, smsJQuery);
            }
            // Show response from iSMS
            Send_Status_richTextBox.AppendText("\n\niSMS Query Jobs Response: " + respon);
         
        }

        private string enc_message(String enc_smsText)
        {
            
            if (enc_smsText.Length < 1) return "";
            
            if (Send_Enc_combobox.SelectedIndex == 2)
            {
                Send_encBytes = unicode.GetBytes(enc_smsText);
                String hex = BitConverter.ToString(Send_encBytes);
                hex = hex.Replace("-00", "");
                hex = hex.Replace("-", ";");
                enc_smsText = hex;
            }
                        
            // If sending HTTP then spaces and quotes should be converted.
            if (Send_isHTTP)
            {
                if (Send_Enc_combobox.SelectedIndex != 2)
                {
                    //Send_SMSText = enc_smsText.Replace(" ", "%20"); // Replace any spaces with %20
                    if (iso_enabled == true)
                    {
                        //Send_SMSText = System.Web.HttpUtility.UrlEncode(enc_smsText, System.Text.Encoding.GetEncoding("ISO-8859-1"));
                        enc_smsText = System.Web.HttpUtility.UrlEncode(enc_smsText, System.Text.Encoding.GetEncoding("ISO-8859-1"));
                    }
                    else
                    {
                        //Send_SMSText = System.Web.HttpUtility.UrlEncode(enc_smsText, System.Text.Encoding.UTF8);
                        enc_smsText = System.Web.HttpUtility.UrlEncode(enc_smsText, System.Text.Encoding.UTF8);
                    }
                }

                // Replace any spaces with %20
                //Send_SMSText = Send_SMSText.Replace(" ", "%20");
                // Replace any double quuoes " with %22
                //Send_SMSText = Send_SMSText.Replace("\"", "%22");
            }
            Console.WriteLine("Encoded text(send): " + Send_SMSText);
            Console.WriteLine("Encoded text: " + enc_smsText);
            return enc_smsText;
        }

        private void QMsg_Last_button_Click(object sender, EventArgs e)
        {
            Send_MsgID_textBox.Text = Send_LastMsgID;
        }

                
        private void Logger(String File_Name, String EntryString)
        {
            if (logs_enable==false || File_Name.Length < 1) return;
            String PathName = logs_folder + logs_prefix + File_Name;
            try
            {
                using (StreamWriter writer = new StreamWriter(PathName, true))
                {
                    writer.WriteLine(EntryString);
                    writer.Close();
                }
            }
            catch (System.Exception e)
            {
                Console.WriteLine("Error writing to log file: " + PathName);
            }
        }

        private void Recv_doPause()
        {
            // Re-enable server settings when server stops. Disable stop button.
            recv_running = false;
            Recv_Port_textBox.Enabled = true;
            Recv_Protocol_comboBox.Enabled = true;
            tableSize_textBox.Enabled = true;
            Start_Recv_button.Text = "Start Recv Server";

            // Shutdown Server
            if (Recv_isHTTP)
            {
                theHTTPserver.CloseServer();
                Recv_Domain_textBox.Enabled = true;
            }
            else
                theTCPserver.CloseServer();

        }

        private void Recv_doResume()
        {
            recv_running = true;
            if ((string)Recv_Protocol_comboBox.SelectedItem == "HTTP")
                Recv_isHTTP = true;
            else
                Recv_isHTTP = false;

            // Get Port setting, convert to number.
            try
            { Recv_Port = Convert.ToInt32(Recv_Port_textBox.Text, 10); }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Invalid Port Value");
                return;
            }
                        
            try
            {  
                int tableSize = Convert.ToInt32(tableSize_textBox.Text, 10);
                if (tableSize < Recv_Table_Row_Count)
                    Recv_Table_Clear();
                Recv_Table_Max_Rows = tableSize;
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Invalid Table Size");
                return;
            }


            Recv_Domain = Recv_Domain_textBox.Text;

            // Disable able Server settings and start button while server is running.
            Recv_Port_textBox.Enabled = false;
            Recv_Protocol_comboBox.Enabled = false;
            Recv_Domain_textBox.Enabled = false;
            tableSize_textBox.Enabled = false;
            Start_Recv_button.Text = "Stop Recv Server";

            // Check if combo box is set to HTTP
            if (Recv_isHTTP)
            {
                // Start HTTP server with current settings.
                String uriprefix = "http://" + Recv_Domain + ":" + Recv_Port + "/";
                theHTTPserver.Start(uriprefix);
            }
            else
            {
                // Start TCP server with current port setting.\
                theTCPserver.Start(Recv_Port);
            }

        }
                        
        private void Send_doResume()
        {          
            if ((string)Send_Protocol_comboBox.SelectedItem == "HTTP")
                Send_isHTTP = true;
            else
                Send_isHTTP = false;

            // Get data from dialog items and verify that all dialogs were filled in.
            // Prep SMS info strings to make build SMS message easier later.
            if (Send_IPAddress_textBox.Text.Length < 4)
            {
                Send_Status_richTextBox.Text = "Please enter the iSMS IP Address";
                return;
            }
            Send_IPAddress = Send_IPAddress_textBox.Text;


            if (Send_Port_textBox.Text.Length < 1)
            {
                Send_Status_richTextBox.Text = "Please enter a Port number";
                return;
            }
            Send_Port = Send_Port_textBox.Text;

            string sRequest = "/sendmsg?";

            if (Send_Username_textBox.Text.Length < 4)
            {
                Send_Status_richTextBox.Text = "Please enter a Username";
                return;
            }
            Send_Username = Send_Username_textBox.Text;
            sRequest += "user=" + Send_Username;
            
            if (Send_Password_textBox.Text.Length < 1)
            {
                Send_Status_richTextBox.Text = "Please enter a Password";
                return;
            }
            Send_Password = Send_Password_textBox.Text;
            sRequest += "&passwd=" + Send_Password;

            sRequest += "&cat=1";

            Send_Encoding = Send_Enc_combobox.SelectedIndex;
            sRequest += "&enc=" + Send_Encoding;

            
            if (Send_Priority_textbox.Text.Length > 0)
            {
                Send_Priority = Convert.ToInt32(Send_Priority_textbox.Text, 10);
                sRequest += "&priority=" + Send_Priority.ToString();
            }

            if ( Send_Modem_textBox.Text.Length > 0)
            {
                int tempModem = Convert.ToInt32(Send_Modem_textBox.Text, 10);
                if (tempModem > 0 && tempModem <= 8)
                {
                    Send_Modem = Send_Modem_textBox.Text;
                    sRequest += "&modem=" + Send_Modem;
                }
            }


            if (Send_To_textBox.Text.Length < 10 && Send_toGroup_textBox.Text.Length<1)
            {
                Send_Status_richTextBox.Text = "Please enter a To phone number or group";
                return;
            }
            if (Send_To_textBox.Text.Length > 0)
            {
                Send_To = Send_To_textBox.Text;
                Parse_SendTo_for_Numbers(Send_To);
                //sRequest += "&to=" + "\"" + Send_To + "\"";
                //???? parse multiple numbers
            }
            if (Send_toGroup_textBox.Text.Length > 0)
            {
                Send_toGroup = Send_toGroup_textBox.Text;
                sRequest += "&group=" + "\"" + Send_toGroup + "\"";
            }

            
            if (Send_Message_richTextBox.Text.Length < 1)
            {
                Send_Status_richTextBox.Text = "Please enter a message";
                return;
            }
            Send_SMSText = Send_Message_richTextBox.Text;
            //sRequest += "&text="; // +Send_SMSText;
            
            if (Send_isHTTP)
            {
                string smsPort = "";
                if (Send_Port.Length > 0)
                    smsPort = ":" + Send_Port;
                    Send_Request_String = "http://" + Send_IPAddress + smsPort + sRequest; 
            }
            else
            {
                // The Message will be sent using TCP
                Send_Request_String = sRequest; // "/sendmsg?" + smsUsername + smsPassword + smsCat + smsPriority + smsTo; // +Send_SMSText + "\r\n";
                Send_tcpIPAddress = Send_IPAddress;
                Send_tcpPort = Convert.ToInt32(Send_Port, 10);
            }
                       

            do_tick();
            
            Logs_UpdateDialog();

        }
        
        // This function clears the incoming message table.
        private void Recv_ClearTable_button_Click(object sender, EventArgs e)
        {
            Recv_Table_Clear();
        }

        private void Recv_Table_Clear()
        {
            Recv_Table_Row_Count = -1;
            Recv_Messages_Count = 0;
            Messages_dataGridView.Rows.Clear();
        }

        private void Send_Status_richTextBox_TextChanged(object sender, EventArgs e)
        {
            if (Send_Status_richTextBox.Text.Length > 16000)
                Send_Status_richTextBox.Text = Send_Status_richTextBox.Text.Substring(Send_Status_richTextBox.Text.Length - 400, 400);
         
            if (Send_StatusAutoScroll_checkBox.Checked)
            {
                Send_Status_richTextBox.SelectionStart = Send_Status_richTextBox.Text.Length;
                Send_Status_richTextBox.ScrollToCaret();
            }
        }
               
                
        private void Logs_SendLive_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            ViewLog_Form viewLogDlg = new ViewLog_Form();
            viewLogDlg.Show();
            viewLogDlg.pathname = logs_folder + logs_prefix + logs_sendlive_name;
            viewLogDlg.diplaystring = "";
            viewLogDlg.doUpdate();
        }

        private void Logs_SendMsgs_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            ViewLog_Form viewLogDlg = new ViewLog_Form();
            viewLogDlg.Show();
            viewLogDlg.pathname = logs_folder + logs_prefix + logs_sendmsg_name;
            viewLogDlg.diplaystring = "";
            viewLogDlg.doUpdate();
        }

        private void Logs_SendFail_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            ViewLog_Form viewLogDlg = new ViewLog_Form();
            viewLogDlg.Show();
            viewLogDlg.pathname = logs_folder + logs_prefix + logs_sendfail_name;
            viewLogDlg.diplaystring = "";
            viewLogDlg.doUpdate();
        }

        private void Logs_RecvLive_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            ViewLog_Form viewLogDlg = new ViewLog_Form();
            viewLogDlg.Show();
            viewLogDlg.pathname = logs_folder + logs_prefix + logs_recvlive_name;
            viewLogDlg.diplaystring = "";
            viewLogDlg.doUpdate();
        }

        private void Logs_RecvMsgs_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            ViewLog_Form viewLogDlg = new ViewLog_Form();
            viewLogDlg.Show();
            viewLogDlg.pathname = logs_folder + logs_prefix + logs_recvmsg_name;
            viewLogDlg.diplaystring = "";
            viewLogDlg.doUpdate();
        }
                

        private void Send_Modem_textBox_TextChanged(object sender, EventArgs e)
        {

        }

        private void Send_Enc_combobox_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void Send_Priority_textbox_TextChanged(object sender, EventArgs e)
        {

        }

        private void Parse_SendTo_for_Numbers(string SendToStr)
        {
            total_numbers = 0;
            number_count = 1;
            if (SendToStr.Length < 7) return;

            int startpos = 0;
            int endpos = 0;
            int done = 0;
            while (done == 0)
            {
                total_numbers++;
                endpos = SendToStr.IndexOf(',', startpos);
                if (endpos < 0)
                {
                    number_list[total_numbers] = SendToStr.Substring(startpos);
                    //MessageBox.Show("startpos=" + startpos.ToString() + ", last number found: " + number_list[total_numbers]);
                    return;
                }
                number_list[total_numbers] = SendToStr.Substring(startpos, endpos - startpos);
                startpos += endpos - startpos + 1;
            }

        }

        private void iso88591_checkBox_CheckedChanged(object sender, EventArgs e)
        {
            if (iso88591_checkBox.Checked)
            {
                iso_enabled = true;
                theHTTPserver.iso_enabled = true;
            }
            else
            {
                iso_enabled = false;
                theHTTPserver.iso_enabled = false;
            }
        }

        private void Test_SendPause_button_Click_1(object sender, EventArgs e)
        {
            Send_doResume();
        }

        private void Test_RecvPause_button_Click_1(object sender, EventArgs e)
        {
            if (recv_running)
                Recv_doPause();
            else
                Recv_doResume(); 
        }

        private void Start_Log_button_Click(object sender, EventArgs e)
        {
            logs_folder = Logs_Folder_textBox.Text;
            logs_prefix = Logs_Prefix_textBox.Text;
            if (logs_enable)
                logs_enable = false;
            else
                logs_enable = true;
            Logs_UpdateDialog();
        }
    }
}
